<?php
/*
	copyright epikurieu 2011

    This file is part of Fluid.

    Fluid is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Fluid is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Fluid.  If not, see <http://www.gnu.org/licenses/>.

*/
class Cms_Form
{

	const ROOT_NAME = 'cms';
	const TYPE_TEXT_2_HTML = 'text2Html';
	const TYPE_HTML_2_HTML = 'html2Html';
	const ENCODING = 'utf-8';
	
	protected $_cols = array(), $_tabParts = array(), $_parser, $_tabType = array();
	
	function setUrl($url)
	{
		$this->_parser = $this->_parserFactory($url);
	}
	
	function parse()
	{
		$this->_parser->parse();
		$this->_parser->group();
		$this->_cols = $this->_parser->getCols();
	}
	
	function getCols()
	{
		return $this->_cols;
	}
	
	function getName()
	{
		$str = self::ROOT_NAME;
		foreach ($this->_tabParts as $part) {
			$str .= '[' . $part . ']';
		}
		return $str;
	}
	
	function getValue()
	{
		$tabTmp = $this->_cols;
		foreach ($this->_tabParts as $part) {
			$tabTmp = $tabTmp[$part];
		}		
		return $tabTmp;
		/*$keyStr = implode('.', $this->_tabParts);
		if (isset($this->_tabType[$keyStr]) && $this->_tabType[$keyStr] == self::TYPE_TEXT_2_HTML) {
			return html_entity_decode($tabTmp, ENT_QUOTES, self::ENCODING);
		} else {
			
		}*/
	}
	
	/**
	 * $key est une chaîne structurée comme suit : champ.clé1.clé2
	 * Cette méthode définit que ce champ et tous ces "fils" seront écrits par l'utilisateur en texte simple et transformés en html pour le fichier
	 */
	function setText2Html($key)
	{
		$this->_setTypeCol($key, self::TYPE_TEXT_2_HTML);
	}
	
	protected function _setTypeCol($key, $value)
	{
		$this->_tabType[$key] = $value;
	}	
	
	/**
	 * Les champs sont faits de parties clé1.clé2.clé3...etc. Dit autrement : clé$deep0.clé$deep1.clé$deep2...etc
	 * Cette méthode sert à modifier dynamiquement ce champ
	 * Si $deep vaut NULL, cela ajoute un "fils"
	 * Sinon, cela modifie un "noeud" et efface tous les "fils"
	 */
	function setPart($keyPart, $deep=NULL)
	{
		if (isset($deep)) {
			$this->_tabParts[$deep] = $keyPart;
			$this->_tabParts = array_slice($this->_tabParts, 0, $deep+1);
		} else {
			$this->_tabParts[] = $keyPart;
		}
	}
	
	function update($post)
	{
		$this->_update($post[self::ROOT_NAME], '');
	}
	
	protected function _parserFactory($url)
	{
		include_once 'Cms/Parser.php';
		return new Cms_Parser($url);
	}
	
	protected function _update($tab, $strKey = '', $type = self::TYPE_HTML_2_HTML)
	{
		$i = 0;
		foreach ($tab as $key => $subTab) {
			if ($strKey != '') $newStrKey = $strKey . '.' . $key;
			else $newStrKey = $key;
			if (isset($this->_tabType[$newStrKey])) $newType = $this->_tabType[$newStrKey];
			else $newType = $type;
			if (is_array($subTab)) {
				$this->_update($subTab, $newStrKey, $newType);
			} else {
				if ($strKey != '' && $subTab == '' && $i>0) {
					$this->_parser->deleteCol($newStrKey);
				}
				else {
					$this->_parser->setCol($newStrKey, $this->_transform($newType, stripslashes($subTab)));
				}
			}
			$i++;
		}
	}
	
	protected function _transform($type, $value)
	{
		if ($type == self::TYPE_TEXT_2_HTML) {
			return htmlspecialchars($value, ENT_COMPAT, self::ENCODING);
		} else {
			return $value;
		}
	}

}

?>