<?php
/*
	copyright epikurieu 2011

    This file is part of Fluid.

    Fluid is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Fluid is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Fluid.  If not, see <http://www.gnu.org/licenses/>.

*/
class Cms_Login
{
	protected $_login = '', $_password = '', $_urlRedirectLogin = '', $_urlRedirectSuccess = '';

	function setIdentityRef($login, $password)
	{
		$this->_login = $login;
		$this->_password = $password;
	}
	
	function setRedirectLogin($url)
	{
		$this->_urlRedirectLogin = $url;
	}
	
	function setRedirectSuccess($url)
	{
		$this->_urlRedirectSuccess = $url;
	}
	
	function manageLog()
	{
		if (!$this->isLogged()) {
			header('Location: ' . $this->_urlRedirectLogin);
			exit();
		}
	}
	
	function isLogged()
	{
		return isset($_SESSION['cms_login']);
	}
	
	function isValid($login, $password)
	{
		return ($login == $this->_login && $this->_password == $password);
	}
	
	
	function success()
	{
		$_SESSION['cms_login'] = $this->_login;
		header('Location: ' . $this->_urlRedirectSuccess);
		exit();
	}

}

?>