<?php
/*
	copyright epikurieu 2011

    This file is part of Fluid.

    Fluid is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Fluid is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Fluid.  If not, see <http://www.gnu.org/licenses/>.

*/


/**
 * les documents sont structurés avec les signes : <!--cms-nomChamp--> <!--/cms--> pour délimiter les zones
 * chaque zone peut être cherchée par son nom et modifiée par ce même nom.
 * Pour modifier : setCol($colName, $content)
 * pour chercher : getCol($colName)
 */
class Cms_Parser
{

	protected $_initCols;
	protected $_cols = array();
	protected $_url, $_file;

	/**
	 * $file peut être un objet ou une url
	 */
	function __construct($file)
	{
		if (is_object($file)) {
			$this->_url = $file->getPathname();
			$this->_file = $file;
		} else {
			$this->_file = new SplFileObject($file);
			$this->_url = $file;
		}
		
		$this->parse();
	}
	
	function parse()
	{
		$this->_cols = $this->_getCols($this->_url);
	}

	function getCol($colName)
	{		
		return $this->_cols[$colName];
	}
	
	function setCol($colName, $content)
	{
		$pattern = "|(<!--cms-$colName-->)(.*)(<!--/cms-->)|Us";
		$fileContent = file_get_contents($this->_url);
		if (preg_match($pattern, $fileContent)) {
			$content = str_replace ( array('\\','$') , array('\\\\','\$') , $content);
			$allContent = preg_replace($pattern,
				'${1}' . $content . '${3}' ,
				file_get_contents($this->_url));
			file_put_contents($this->_url, $allContent);
			$this->_cols[$colName] = $content;
		} elseif (isset($content) && $content != '') {
			$this->addCol($colName, $content);
		}
	}
	
	function deleteCol($colName)
	{
		$allContent = preg_replace("|(<!--cms-$colName-->).*(<!--/cms-->)|Us",
    		'' ,
    		file_get_contents($this->_url));
		file_put_contents($this->_url, $allContent);
		if (isset($this->_cols[$colName])) unset($this->_cols[$colName]);
	}
	
	function addCol($colName, $content)
	{
		file_put_contents($this->_url, file_get_contents($this->_url) . "\r\n\r\n" . "<!--cms-$colName-->" . $content . "<!--/cms-->");
	}

	/**
	 * si les champs utilisent la syntaxe "colonne.cle1.cle2", cela permet de grouper dans un sous tableau $this->_cols[colonne][cle1][cle2], etc...
	 */
	function group()
	{
		foreach ($this->_cols as $key => $col) {
			$tab = explode('.', $key);
			$this->_getValueGroup($tab, $col, $colsTmp);
		}
		$this->_cols = $colsTmp;
	}
	
	function getCols()
	{
		return $this->_cols;
	}
	
	/**
	 * renvoie un lien (valide pour le navigateur) correspondant au parser
	 * si $context est défini, l'url sera relative à ce contexte
	 */
	function getLink($context = NULL)
	{
		$link = str_replace($_SERVER['DOCUMENT_ROOT'], '',$this->_file->getPathname());
		
		$lastChar = strlen($context) - 1;
		if (isset($context)) {
			if ($context{$lastChar} != '/') $context = $context . '/';	
			if ($context{0} != '/') $context = '/' . $context;	
			$link = str_replace($context, '', $link);
		}
		return $link;
	}
	
	/**
	 * renvoie l'objet fichier associé
	 */
	function getFile()
	{
		return $this->_file;
	}
	
	protected function _getValueGroup($tab, $value, & $constructCol)
	{
		if (sizeof($tab)>0) {	
			$key = array_shift($tab);
			$futureCol = &$constructCol[$key];
			$this->_getValueGroup($tab, $value, $futureCol);
		} else {
			$constructCol = $value;
		}
	}

	protected function _getCols($url)
	{
		preg_match_all("|<!--cms-([^>]+)-->(.*)<!--/cms-->|Us",
    		file_get_contents($url) ,
    		$out, PREG_SET_ORDER);
		
		$cols = array();
		foreach ($out as $regs) {
			$key  = $regs[1];
			$content = $regs[2];
			$cols[$key] = $content;
		}
		
		return $cols;
	}
	
}




?>